﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using Class_Library;

public partial class AnAddress : System.Web.UI.Page
{
    //variable to store the primary key with page level scope
    Int32 AddressID;

    //event handler for the page load event
    protected void Page_Load(object sender, EventArgs e)
    {
        //get the number of the address to be processed
        AddressID = Convert.ToInt32(Session["AddressID"]);
        if (IsPostBack == false)
        {
            //populate the list of counties
            DisplayCounties();
            //if this is not a new record
            if (AddressID != -1)
            { 
                //display the current data for the record
                DisplayAddress();
            }
        }
    }

    //function for populating the county drop down list
    void DisplayCounties()
    {
        //create an instance of the County Collection
        Class_Library.clsCountyCollection Counties = new Class_Library.clsCountyCollection();
        //set the data source to the list of counties in the collection
        ddlCounty.DataSource = Counties.AllCounties;
        //set the name of the primary key
        ddlCounty.DataValueField = "CountyNo";
        //set the data field to display
        ddlCounty.DataTextField= "County";
        //bind the data to the list
        ddlCounty.DataBind();
    }

    //this is the event handler for the cancel button
    protected void btnCancel_Click(object sender, EventArgs e)
    {
        //redirect to the main page
        Response.Redirect("Default.aspx");
    }

    //event handler for the ok button
    protected void btnOK_Click(object sender, EventArgs e)
    {
        if (AddressID == -1)
        {
            //add the new record
            Add();
        }
        else
        { 
            //update the record
            Update();
        }
    }

    //function for adding new records
    void Add()
    {
        //create an instance of the address book
        clsAddressCollection AddressBook = new clsAddressCollection();
        //validate the data on the web form
        String Error = AddressBook.ThisAddress.Valid(txtHouseNo.Text, txtStreet.Text, txtTown.Text, txtPostCode.Text, txtDateAdded.Text);
        //if the data is OK then add it to the object
        if (Error == "")
        {
            //get the data entered by the user
            AddressBook.ThisAddress.HouseNo = txtHouseNo.Text;
            AddressBook.ThisAddress.Street = txtStreet.Text;
            AddressBook.ThisAddress.Town = txtTown.Text;
            AddressBook.ThisAddress.PostCode = txtPostCode.Text;
            AddressBook.ThisAddress.DateAdded = Convert.ToDateTime(txtDateAdded.Text);
            AddressBook.ThisAddress.Active = chkActive.Checked;
            AddressBook.ThisAddress.CountyNo = Convert.ToInt32(ddlCounty.SelectedValue);
            //add the record
            AddressBook.Add();
            //all done so redirect back to the main page
            Response.Redirect("Default.aspx");
        }
        else
        {
            //report an error
            lblError.Text = "There were problems with the data entered " + Error;
        }
    }

    //function for updateing records
    void Update()
    {
        //create an instance of the address book
        Class_Library.clsAddressCollection AddressBook = new Class_Library.clsAddressCollection();
        //validate the data on the web form
        String Error = AddressBook.ThisAddress.Valid(txtHouseNo.Text, txtStreet.Text, txtTown.Text, txtPostCode.Text, txtDateAdded.Text);
        //if the data is OK then add it to the object
        if (Error == "")
        {
            //find the record to update
            AddressBook.ThisAddress.Find(AddressID);
            //get the data entered by the user
            AddressBook.ThisAddress.HouseNo = txtHouseNo.Text;
            AddressBook.ThisAddress.Street = txtStreet.Text;
            AddressBook.ThisAddress.Town = txtTown.Text;
            AddressBook.ThisAddress.PostCode = txtPostCode.Text;
            AddressBook.ThisAddress.DateAdded = Convert.ToDateTime(txtDateAdded.Text);
            AddressBook.ThisAddress.Active = chkActive.Checked;
            AddressBook.ThisAddress.CountyNo = Convert.ToInt32(ddlCounty.SelectedValue);
            //update the record
            AddressBook.Update();
            //all done so redirect back to the main page
            Response.Redirect("Default.aspx");
        }
        else
        {
            //report an error
            lblError.Text = "There were problems with the data entered " + Error;
        }
    }

    void DisplayAddress()
    {
        //create an instance of the address book
        clsAddressCollection AddressBook = new clsAddressCollection();
        //find the record to update
        AddressBook.ThisAddress.Find(AddressID);
        //display the data for this record
        txtHouseNo.Text = AddressBook.ThisAddress.HouseNo;
        txtStreet.Text = AddressBook.ThisAddress.Street;
        txtTown.Text = AddressBook.ThisAddress.Town;
        txtPostCode.Text = AddressBook.ThisAddress.PostCode;
        txtDateAdded.Text = AddressBook.ThisAddress.DateAdded.ToString();
        chkActive.Checked = AddressBook.ThisAddress.Active;
        ddlCounty.SelectedValue = AddressBook.ThisAddress.CountyNo.ToString();
    }
}